{*******************************************************************************
 *                               Uhr  Version 1.1                              *
 *                 (c) 2001 Ulrich Borghoff Gymnasium Wilnsdorf                *
 *                           eMail: sum-delphi@web.de                          *
 *                                                                             *
 * Diese Uhr Version drfte auf allen Delphi Versionen ab 1.16 laufen...       *
 *                                                                             *
 * Fr den Unterricht sollten Sie nur die mUhr.dcu Datei verwenden. Diese      *
 * muss sich im Ordner ..delphi/lib befinden. Die Angabe "uses mUhr" ist       *
 * dann schon ausreichend.                                                     *
 *                                                                             *
 * Danke fr Ihre Mitarbeit.                                                   *
 *******************************************************************************}

unit mUhr;

interface

uses mSuM,winprocs,sysutils;

type Uhr=class

  zStartzeit,zStoppzeit:GanzeZahl;

  constructor init;
  function datum:Zeichenkette;
  function zeit:Zeichenkette;

  function tag:GanzeZahl;
  function monat:GanzeZahl;
  function jahr:GanzeZahl;
  function stunde:GanzeZahl;
  function minute:GanzeZahl;
  function sekunde:GanzeZahl;
  function millisekunde:GanzeZahl;
  procedure warte(pMillisekunden: Ganzezahl);

  procedure starte;
  procedure stoppe;
  function gestoppteZeit:Zahl;

  destructor gibFrei;
end;

implementation

  constructor Uhr.init;
  begin
    randomize;
  end;

  function Uhr.datum:Zeichenkette;
  begin
    result:=DateToStr(Date);
  end;

  function Uhr.zeit:Zeichenkette;
  begin
    result:=TimeToStr(Time);;
  end;

  function Uhr.tag:GanzeZahl;
   var lJahr, lMonat, lTag: Word;
  begin
    DecodeDate(Date, lJahr, lMonat, lTag);
    result:=lTag;
  end;

  function Uhr.monat:GanzeZahl;
   var lJahr, lMonat, lTag: Word;
  begin
    DecodeDate(Date, lJahr, lMonat, lTag);
    result:=lMonat;
  end;

  function Uhr.jahr:GanzeZahl;
   var lJahr, lMonat, lTag: Word;
  begin
    DecodeDate(Date, lJahr, lMonat, lTag);
    result:=lJahr;
  end;

  function Uhr.stunde:GanzeZahl;
   var lStunde, lMinute, lSekunde, lMillisekunde: Word;
  begin
    DecodeTime(Time, lStunde, lMinute, lSekunde, lMillisekunde);
    result:=lStunde;
  end;

  function Uhr.minute:GanzeZahl;
   var lStunde, lMinute, lSekunde, lMillisekunde: Word;
  begin
    DecodeTime(Time, lStunde, lMinute, lSekunde, lMillisekunde);
    result:=lMinute;
  end;

  function Uhr.sekunde:GanzeZahl;
   var lStunde, lMinute, lSekunde, lMillisekunde: Word;
  begin
    DecodeTime(Time, lStunde, lMinute, lSekunde, lMillisekunde);
    result:=lSekunde;
  end;

  function Uhr.millisekunde:GanzeZahl;
   var lStunde, lMinute, lSekunde, lMillisekunde: Word;
  begin
    DecodeTime(Time, lStunde, lMinute, lSekunde, lMillisekunde);
    result:=lMillisekunde;
  end;

  procedure Uhr.warte(pMillisekunden:GanzeZahl);
    var Sollzeit:longint;
  begin
    Sollzeit:= GetTickCount + pMillisekunden;
    while GetTickCount < int(Sollzeit) do
      ;
  end;

  procedure Uhr.starte;
  begin
    zStartzeit:=GetTickCount;
  end;

  procedure Uhr.stoppe;
  begin
    zStoppzeit:=GetTickCount;
  end;

  function Uhr.gestoppteZeit:Zahl;
  begin
    result:=(zStoppzeit-zStartzeit)/1000;
  end;

  destructor Uhr.gibFrei;
  begin
  end;

end.

